//
// Polygon Array.js
//
//  v.100119
//  required version : Cheetah3D v3.4
//
//  (c) 2006, 2007, 2010 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2006-10-05 created.
// 2006-10-07 still beta.. :(
// 2006-10-10 change code by Martin's hint. :)
// 2006-10-11 .... have problem yet.
// 2007-05-17 at last. :p
// 2007-05-18 add parameters for position.
// 2008-11-20 fixed UV error problem.
// 2010-01-19 add random children copy option
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select this script from Tools -> Scritp -> Polygon Script
//

var randoms = new Array;
var copy_randoms = new Array;
var random_count = 200;

/*
Vec2D.prototype.toString = function() {
	return this.u.toFixed(6) + ', ' + this.v.toFixed(6);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(6) + ', ' + this.y.toFixed(6) + ', ' + this.z.toFixed(6);
}
Vec3D.prototype.normalize = function() {
	var l = this.norm();
	return (l < 0.000001 ) ? new Vec3D() : this.multiply(1/l);
}
*/

function buildUI(obj){
    var normalType, normalAngle;
    
    obj.setParameter("name","Polygon Array");
    
    obj.addParameterBool("rotate along normal",1,0,1,true,true);
    
    obj.addParameterSelector("copy type", ["random", "poly sel"], true, true);
    obj.addParameterSelector("poly selection", ["child's index", "child's polysel"], true, true);
    
    obj.addParameterBool("random variation",0,0,1,true,true);
    
    obj.addParameterFloat("pos amount X",0,-1000,1000,true,true);
    obj.addParameterFloat("pos amount Y",0,-1000,1000,true,true);
    obj.addParameterFloat("pos amount Z",0,-1000,1000,true,true);
    
    obj.addParameterFloat("angle H",0,-180,180,true,true);
    obj.addParameterFloat("angle P",0,-180,180,true,true);
    obj.addParameterFloat("angle B",0,-180,180,true,true);
    
    obj.addParameterBool("keep proportion",1,0,1,true,true);
    obj.addParameterFloat("scale amount X",0,-1000,1000,true,true);
    obj.addParameterFloat("scale amount Y",0,-1000,1000,true,true);
    obj.addParameterFloat("scale amount Z",0,-1000,1000,true,true);

    obj.addParameterBool("make creator",0,0,1,true,true);
    
    obj.addParameterFloat("update timer",0,0,1000,true,true);
    
    obj.addParameterButton("update","Update","objectUpdate");
    
    obj.setParameter("normalType",2);
    obj.setParameter("normalAngle",45.0);
    
    obj.addParameterSeparator("Smooth");
    obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
    
    obj.setParameter("smooth",2);
}

function objectUpdate(obj) {
    obj.update();
}

function copyCoreToVertex(core, cCore, cMat, posV, scaleV, rotV, cPos, cRot, iter, polysel_type) {
    var i, j;
    var polyCount = cCore.polygonCount();
    var vertexCount = cCore.vertexCount();
    
    var trans = new Mat4D(TRANSLATE,posV.x,posV.y,posV.z);
    var scale = new Mat4D(SCALE,scaleV.x,scaleV.y,scaleV.z);
    var rot = new Mat4D(ROTATE_HPB,rotV.x,rotV.y,rotV.z);
    
    var cmPos = new Mat4D(TRANSLATE,cPos.x,cPos.y,cPos.z);
    var cmRot = new Mat4D(ROTATE_HPB,cRot.x,cRot.y,cRot.z);

    for (i = 0;i < vertexCount;i++) {
        var vert = cmPos.multiply(cmRot.multiply(cMat.multiply(cCore.vertex(i))));
        vert = trans.multiply(rot.multiply(scale.multiply(vert)));
        core.addVertex(false, vert);
    }
    for (i = 0;i < polyCount;i++) {
        var size = cCore.polygonSize(i);
        var verts = new Array;
        var uvs = new Array;
        for (j = 0;j < size;j++) {
            verts[j] = cCore.vertexIndex(i, j)+(iter);
			var uv = cCore.uvCoord(i,j);
            uvs[j] = new Vec2D(uv.x, uv.y);
        }
        var pi = core.addIndexPolygon(size, verts, uvs);
	    if (polysel_type == null) {
			for (var bi = 0;bi < 16;bi++) {
				cCore.setActivePolygonSelection( bi );
				core.setActivePolygonSelection( bi );
				core.setPolygonSelection( pi, cCore.polygonSelection( i ) );
			}
	    } else {
	    	core.setActivePolygonSelection( polysel_type );
	    	core.setPolygonSelection( pi, true );
	    }
    }
}

function buildObject(obj){
    var core = obj.core();
    var i,j,k;
    
    var alignNormal = obj.getParameter("rotate along normal");
    
    var variation = obj.getParameter("random variation");
    var posx = obj.getParameter("pos amount X");
    var posy = obj.getParameter("pos amount Y");
    var posz = obj.getParameter("pos amount Z");
    var rotx = obj.getParameter("angle H");
    var roty = obj.getParameter("angle P");
    var rotz = obj.getParameter("angle B");
    var proportion = obj.getParameter("keep proportion");
    var scalex = obj.getParameter("scale amount X");
    var scaley = obj.getParameter("scale amount Y");
    var scalez = obj.getParameter("scale amount Z");
    
    var copytype = parseInt(obj.getParameter("copy type"));
    var polysel = parseInt(obj.getParameter("poly selection"));
    
    //obj.setCreatorObj( (obj.getParameter("make creator"))? true : false );
    
    //print("----- Polygon Array -----");
    
    if (obj.childCount() > 1) {
        var base = obj.childAtIndex(0);
        var guide = obj.childAtIndex(1);
        var baseCore_list = [];
        var baseMat_list = [];
        
        if ( guide.family() == NGONFAMILY && ( base.family() == NGONFAMILY || base.type() == FOLDER ) ) {
            // smooth
            obj.setParameter("normalType",obj.getParameter("smooth"),false);
            obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
            
            // getting base polyCore
            var guideCore = guide.modCore();
            var guideMat = guide.objMatrix();
            var guidePolyCount = guideCore.polygonCount();
            
            var base_index;
            var baseCore;
            var baseMat;
            
            if (base.type() == FOLDER) {
            	if (base.childCount() < 1) return;
            	
            	for (i = 0;i < base.childCount();i++) {
            		var base_child = base.childAtIndex(i);
            		
            		if (base_child.family() == NGONFAMILY) {
            			baseCore_list.push( base_child.modCore() );
            			baseMat_list.push( base_child.objMatrix() );
            		}
            	}
            	
            } else {
            	
            	baseCore_list.push( base.modCore() );
            	baseMat_list.push( base.objMatrix() );
            }
            
            //OS.system("echo list:"+baseCore_list+':'+baseMat_list);
            
            // error check
            if (baseCore_list.length < 0) return;
            
            if (! randoms.length) {
                for (i = 0;i < random_count;i++) {
                    randoms[i] = [ Math.random(), Math.random(), Math.random() ];
                    copy_randoms[i] = Math.random();
                }
            }
            //print("copy count:"+guidePolyCount);
            for (i = 0;i < guidePolyCount;i++) {
                var random_i = i % random_count;
                var gSize = guideCore.polygonSize(i);
                var gVert = new Vec3D(0,0,0);
                var gScale = new Vec3D(1,1,1);
                var gNormal = guideCore.normal(i);
                
                for (j = 0;j < gSize;j++) {
                    var vertIndex = guideCore.vertexIndex(i,j);
                    var vert = guideCore.vertex(vertIndex);
                    gVert = gVert.add(vert);
                }
                gVert = guideMat.multiply(gVert.multiply(1/gSize));
                
                if (alignNormal == 1) {
                    var theta = Math.acos(gNormal.y)*180/Math.PI;
                    var phi = Math.atan2(gNormal.x,gNormal.z)*180/Math.PI;
                    
                    var gRot = new Vec3D(phi,theta,0);
                    
                } else {
                    var gRot = new Vec3D(0,0,0);
                }
                
                if (variation) {
                    var cPos = new Vec3D(randoms[random_i][0]*posx - posx/2, randoms[random_i][0]*posy - posy/2, randoms[random_i][0]*posz - posz)
                    var cRot = new Vec3D(randoms[random_i][0]*rotx/2-rotx/2, randoms[random_i][1]*roty/2-roty/2, randoms[random_i][2]*rotz/2-rotz/2);
                    if (proportion) gScale = gScale.add(new Vec3D(randoms[random_i][0]*scalex, randoms[random_i][0]*scalex, randoms[random_i][0]*scalex));
                    else gScale = gScale.add(new Vec3D(randoms[random_i][0]*scalex, randoms[random_i][1]*scaley, randoms[random_i][2]*scalez));
                } else {
                    var cPos = new Vec3D(posx, posy, posz);
                    var cRot = new Vec3D(rotx, roty, rotz);
                    if (proportion) gScale = gScale.add(new Vec3D(scalex, scalex, scalex));
                    else gScale = gScale.add(new Vec3D(scalex, scaley, scalez));
                }
                
                base_index = null;
                
                if (copytype) {
                	var base_count = baseCore_list.length;
                	if (base_count > 15) base_count = 15;
                	for (var bi = 0;bi < base_count;bi++) {
                		guideCore.setActivePolygonSelection( bi );
                		if ( guideCore.polygonSelection( i ) ) base_index = bi;
                	}
                } else {
	                base_index = Math.floor( copy_randoms[random_i] * baseCore_list.length );
	            }
                
                if (base_index == null) continue;
                
                baseCore = baseCore_list[ base_index ];
                baseMat = baseMat_list[ base_index ];
                
                //OS.system("echo "+ base_index + ', ' + baseCore + ': ' + baseMat + ': ' + i );
                
                var polysel_type = (polysel)? null : base_index;
                
                if (polysel_type > 15) polysel_type = 0;
                
                copyCoreToVertex(core, baseCore, baseMat, gVert, gScale, gRot, cPos, cRot, core.vertexCount(), polysel_type);
            }
        }
    }
}

